/*
 * Decompiled with CFR 0.152.
 */
package org.kosmix.kosmosfs.access;

import java.io.IOException;
import org.kosmix.kosmosfs.access.KfsInputChannel;
import org.kosmix.kosmosfs.access.KfsOutputChannel;

public class KfsAccess {
    private static final native int initF(String var0);

    private static final native int initS(String var0, int var1);

    private static final native int cd(String var0);

    private static final native int mkdirs(String var0);

    private static final native int rmdir(String var0);

    private static final native String[] readdir(String var0);

    private static final native String[][] getDataLocation(String var0, long var1, long var3);

    private static final native short getReplication(String var0);

    private static final native short setReplication(String var0, int var1);

    private static final native int create(String var0, int var1, boolean var2);

    private static final native int remove(String var0);

    private static final native int rename(String var0, String var1, boolean var2);

    private static final native int open(String var0, String var1, int var2);

    private static final native int exists(String var0);

    private static final native int isFile(String var0);

    private static final native int isDirectory(String var0);

    private static final native long filesize(String var0);

    public KfsAccess(String configFn) throws IOException {
        int res = KfsAccess.initF(configFn);
        if (res != 0) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    public KfsAccess(String metaServerHost, int metaServerPort) throws IOException {
        int res = KfsAccess.initS(metaServerHost, metaServerPort);
        if (res != 0) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    public int kfs_cd(String path) {
        return KfsAccess.cd(path);
    }

    public int kfs_mkdirs(String path) {
        return KfsAccess.mkdirs(path);
    }

    public int kfs_rmdir(String path) {
        return KfsAccess.rmdir(path);
    }

    public String[] kfs_readdir(String path) {
        return KfsAccess.readdir(path);
    }

    public KfsOutputChannel kfs_append(String path) {
        int fd = KfsAccess.open(path, "a", 1);
        if (fd < 0) {
            return null;
        }
        return new KfsOutputChannel(fd);
    }

    public KfsOutputChannel kfs_create(String path) {
        return this.kfs_create(path, 1);
    }

    public KfsOutputChannel kfs_create(String path, int numReplicas) {
        return this.kfs_create(path, numReplicas, false);
    }

    public KfsOutputChannel kfs_create(String path, int numReplicas, boolean exclusive) {
        int fd = KfsAccess.create(path, numReplicas, exclusive);
        if (fd < 0) {
            return null;
        }
        return new KfsOutputChannel(fd);
    }

    public KfsInputChannel kfs_open(String path) {
        int fd = KfsAccess.open(path, "r", 1);
        if (fd < 0) {
            return null;
        }
        return new KfsInputChannel(fd);
    }

    public int kfs_remove(String path) {
        return KfsAccess.remove(path);
    }

    public int kfs_rename(String oldpath, String newpath) {
        return KfsAccess.rename(oldpath, newpath, true);
    }

    public int kfs_rename(String oldpath, String newpath, boolean overwrite) {
        return KfsAccess.rename(oldpath, newpath, overwrite);
    }

    public boolean kfs_exists(String path) {
        return KfsAccess.exists(path) == 1;
    }

    public boolean kfs_isFile(String path) {
        return KfsAccess.isFile(path) == 1;
    }

    public boolean kfs_isDirectory(String path) {
        return KfsAccess.isDirectory(path) == 1;
    }

    public long kfs_filesize(String path) {
        return KfsAccess.filesize(path);
    }

    public String[][] kfs_getDataLocation(String path, long start, long len) {
        return KfsAccess.getDataLocation(path, start, len);
    }

    public short kfs_getReplication(String path) {
        return KfsAccess.getReplication(path);
    }

    public short kfs_setReplication(String path, int numReplicas) {
        return KfsAccess.setReplication(path, numReplicas);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public void release() {
    }

    static {
        try {
            System.loadLibrary("kfs_access");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.err.println("Unable to load kfs_access native library");
            System.exit(1);
        }
    }
}

