/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletOut;
import org.mortbay.jetty.servlet.ServletWriter;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;

public class ServletHttpResponse
implements HttpServletResponse {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$ServletHttpResponse == null ? (class$org$mortbay$jetty$servlet$ServletHttpResponse = ServletHttpResponse.class$("org.mortbay.jetty.servlet.ServletHttpResponse")) : class$org$mortbay$jetty$servlet$ServletHttpResponse));
    public static final int DISABLED = -1;
    public static final int NO_OUT = 0;
    public static final int OUTPUTSTREAM_OUT = 1;
    public static final int WRITER_OUT = 2;
    private static ServletWriter __nullServletWriter;
    private static ServletOut __nullServletOut;
    private HttpResponse _httpResponse;
    private ServletHttpRequest _servletHttpRequest;
    private int _outputState = 0;
    private ServletOut _out = null;
    private ServletWriter _writer = null;
    private HttpSession _session = null;
    private boolean _noSession = false;
    private Locale _locale = null;
    private boolean _explicitEncoding = false;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHttpResponse;

    public ServletHttpResponse(ServletHttpRequest request, HttpResponse response) {
        this._servletHttpRequest = request;
        this._servletHttpRequest.setServletHttpResponse(this);
        this._httpResponse = response;
    }

    void recycle() {
        this._outputState = 0;
        this._out = null;
        this._writer = null;
        this._session = null;
        this._noSession = false;
        this._locale = null;
        this._explicitEncoding = false;
    }

    int getOutputState() {
        return this._outputState;
    }

    void setOutputState(int s) throws IOException {
        if (s < 0) {
            this._outputState = -1;
            if (this._writer != null) {
                this._writer.disable();
            }
            this._writer = null;
            if (this._out != null) {
                this._out.disable();
            }
            this._out = null;
        } else {
            this._outputState = s;
        }
    }

    HttpResponse getHttpResponse() {
        return this._httpResponse;
    }

    void commit() throws IOException {
        if (this._writer != null && this._writer.isWritten()) {
            this._writer.flush();
        } else {
            this._httpResponse.commit();
        }
    }

    void complete() throws IOException {
        this._httpResponse.completing();
        this.commit();
        this.setOutputState(-1);
    }

    public boolean isCommitted() {
        return this._httpResponse.isCommitted();
    }

    boolean isDirty() {
        return this._httpResponse.isDirty();
    }

    public void setBufferSize(int size) {
        HttpOutputStream out = (HttpOutputStream)this._httpResponse.getOutputStream();
        if (out.isWritten() || this._writer != null && this._writer.isWritten()) {
            throw new IllegalStateException("Output written");
        }
        out.setBufferSize(size);
    }

    public int getBufferSize() {
        return ((HttpOutputStream)this._httpResponse.getOutputStream()).getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (((HttpOutputStream)this._httpResponse.getOutputStream()).isClosed()) {
            return;
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        if (this._writer == null && this._out == null) {
            this._httpResponse.getOutputStream().flush();
        }
        if (!this._httpResponse.isCommitted()) {
            this._httpResponse.commit();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        ((HttpOutputStream)this._httpResponse.getOutputStream()).resetBuffer();
        if (this._writer != null) {
            this._writer.reset();
        }
    }

    public void reset() {
        this.resetBuffer();
        this._httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        String charset;
        HttpContext httpContext;
        if (this._outputState != 0 || locale == null || this.isCommitted()) {
            return;
        }
        this._locale = locale;
        this.setHeader("Content-Language", locale.toString().replace('_', '-'));
        String type = this._httpResponse.getField("Content-Type");
        if (type == null) {
            type = "application/octet-stream";
        }
        if ((httpContext = this._servletHttpRequest.getServletHandler().getHttpContext()) instanceof ServletHttpContext && (charset = ((ServletHttpContext)httpContext).getLocaleEncoding(locale)) != null && charset.length() > 0) {
            int semi = type.indexOf(59);
            if (semi < 0) {
                type = type + "; charset=" + charset;
            } else if (!this._explicitEncoding) {
                type = type.substring(0, semi) + "; charset=" + charset;
            }
            this.setHeader("Content-Type", type);
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public void addCookie(Cookie cookie) {
        this._httpResponse.addSetCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._httpResponse.containsField(name);
    }

    public String encodeURL(String url) {
        if (this._servletHttpRequest == null || this._servletHttpRequest.isRequestedSessionIdFromCookie() && this._servletHttpRequest.getServletHandler().isUsingCookies()) {
            return url;
        }
        if (this._session == null && !this._noSession) {
            this._session = this._servletHttpRequest.getSession(false);
            boolean bl = this._noSession = this._session == null;
        }
        if (this._session == null || url == null) {
            return url;
        }
        String id = this._session.getId();
        if (id == null) {
            return url;
        }
        int prefix = url.indexOf(SessionManager.__SessionUrlPrefix);
        if (prefix != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + SessionManager.__SessionUrlPrefix.length()) + id;
            }
            return url.substring(0, prefix + SessionManager.__SessionUrlPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + SessionManager.__SessionUrlPrefix + id;
        }
        return url.substring(0, suffix) + SessionManager.__SessionUrlPrefix + id + url.substring(suffix);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int status, String message) throws IOException {
        String error_page = this._servletHttpRequest.getServletHandler().getErrorPage(status, this._servletHttpRequest);
        this.resetBuffer();
        if (error_page == null) {
            this._httpResponse.sendError(status, message);
        } else {
            ServletHolder holder;
            this._httpResponse.setStatus(status, message);
            if (message == null && (message = (String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(status))) == null) {
                message = "" + status;
            }
            if ((holder = this._servletHttpRequest.getServletHolder()) != null) {
                this._servletHttpRequest.setAttribute("javax.servlet.error.servlet_name", holder.getName());
            }
            this._servletHttpRequest.setAttribute("javax.servlet.error.request_uri", this._servletHttpRequest.getRequestURI());
            this._servletHttpRequest.setAttribute("javax.servlet.error.status_code", new Integer(status));
            this._servletHttpRequest.setAttribute("javax.servlet.error.message", message);
            RequestDispatcher dispatcher = this._servletHttpRequest.getServletHandler().getServletContext().getRequestDispatcher(error_page);
            try {
                ((Dispatcher)dispatcher).error((ServletRequest)this._servletHttpRequest, (ServletResponse)this);
            }
            catch (ServletException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                this._httpResponse.sendError(status, message);
            }
        }
        this.complete();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendRedirect(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (!URI.hasScheme(url)) {
            StringBuffer buf = this._servletHttpRequest.getHttpRequest().getRootURL();
            if (url.startsWith("/")) {
                buf.append(URI.canonicalPath(url));
            } else {
                String path = this._servletHttpRequest.getRequestURI();
                String parent = path.endsWith("/") ? path : URI.parentPath(path);
                url = URI.canonicalPath(URI.addPaths(parent, url));
                if (!url.startsWith("/")) {
                    buf.append('/');
                }
                buf.append(url);
            }
            url = buf.toString();
        }
        this.resetBuffer();
        this._httpResponse.setField("Location", url);
        this._httpResponse.setStatus(302);
        this.complete();
    }

    public void setDateHeader(String name, long value) {
        try {
            this._httpResponse.setDateField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void setHeader(String name, String value) {
        try {
            this._httpResponse.setField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void setIntHeader(String name, int value) {
        try {
            this._httpResponse.setIntField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void addDateHeader(String name, long value) {
        try {
            this._httpResponse.addDateField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void addHeader(String name, String value) {
        try {
            this._httpResponse.addField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void addIntHeader(String name, int value) {
        try {
            this._httpResponse.addIntField(name, value);
        }
        catch (IllegalStateException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void setStatus(int status) {
        this._httpResponse.setStatus(status);
    }

    public void setStatus(int status, String message) {
        this.setStatus(status);
        this._httpResponse.setReason(message);
    }

    public ServletOutputStream getOutputStream() {
        if (this._outputState == -1) {
            return __nullServletOut;
        }
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException();
        }
        if (this._writer != null) {
            this._writer.flush();
            this._writer.disable();
            this._writer = null;
        }
        if (this._out == null) {
            this._out = new ServletOut(this._servletHttpRequest.getHttpRequest().getOutputStream());
        }
        this._outputState = 1;
        return this._out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState == -1) {
            return __nullServletWriter;
        }
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException();
        }
        if (this._out != null) {
            this._out.flush();
        }
        if (this._writer == null) {
            String encoding = this._httpResponse.getCharacterEncoding();
            if (encoding == null) {
                if (this._servletHttpRequest != null) {
                    String mimeType = this._httpResponse.getMimeType();
                    encoding = this._servletHttpRequest.getServletHandler().getHttpContext().getEncodingByMimeType(mimeType);
                }
                if (encoding == null) {
                    encoding = StringUtil.__ISO_8859_1;
                }
                this._httpResponse.setCharacterEncoding(encoding, true);
            }
            this._writer = new ServletWriter(this._httpResponse.getOutputStream(), encoding);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setContentLength(int len) {
        if (!this.isCommitted()) {
            this.setIntHeader("Content-Length", len);
        }
    }

    public String getContentType() {
        return this._httpResponse.getContentType();
    }

    public void setContentType(String contentType) {
        if (this.isCommitted() || contentType == null) {
            return;
        }
        int semi = contentType.indexOf(59);
        if (semi > 0) {
            if (this._outputState == 0) {
                this._explicitEncoding = true;
                this._httpResponse.setContentType(contentType);
            } else {
                this._httpResponse.setContentType(contentType.substring(0, semi));
            }
        } else {
            this._httpResponse.setContentType(contentType);
        }
        if (this._locale != null) {
            this.setLocale(this._locale);
        }
    }

    public void setCharacterEncoding(String encoding) {
        if (this._outputState == 0 && !this.isCommitted()) {
            this._explicitEncoding = true;
            this._httpResponse.setCharacterEncoding(encoding, true);
        }
    }

    public String getCharacterEncoding() {
        String encoding = this._httpResponse.getCharacterEncoding();
        return encoding == null ? StringUtil.__ISO_8859_1 : encoding;
    }

    public String toString() {
        return this._httpResponse.toString();
    }

    public static ServletHttpResponse unwrap(ServletResponse response) {
        while (!(response instanceof ServletHttpResponse)) {
            if (response instanceof ServletResponseWrapper) {
                ServletResponseWrapper wrapper = (ServletResponseWrapper)response;
                response = wrapper.getResponse();
                continue;
            }
            throw new IllegalArgumentException("Does not wrap ServletHttpResponse");
        }
        return (ServletHttpResponse)response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            __nullServletWriter = new ServletWriter(IO.getNullStream());
            __nullServletOut = new ServletOut(IO.getNullStream());
        }
        catch (Exception e) {
            log.fatal((Object)e);
            System.exit(1);
        }
    }
}

